const sendEmail = require('./Email')

class emailTemplate {
    stramptoTime(time) {
        if (time < 10)
            return '';
        return new Date(+time).toLocaleString('zh-CN', { year: 'numeric', month: '2-digit', day: '2-digit', hour: '2-digit', minute: '2-digit' });
    }

    async checkEmail(email, code) {
        const time = new Date().getTime()
        await sendEmail(email, 'GitNexus - 邮箱验证码',
            `<html lang="zh-CN">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>GitNexus - 邮箱验证码</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }

        .container {
            width: 80%;
            margin: 20px auto;
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }

        .head {
            display: flex;
            justify-content: center;
            align-items: center;
            gap:10px;
            color: #2c3e50;
        }

        p {
            font-size: 16px;
            color: #34495e;
            line-height: 1.6;
            text-indent: 2em;
        }

        .code {
            margin: 20px 0;
            font-size: 1.5em;
            text-align: center;
            font-weight: bold;
        }

        .important {
            color: #e74c3c;
            font-weight: bold;
        }

        .footer {
            font-size: 14px;
            text-align: center;
            color: #7f8c8d;
            margin-top: 50px;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="head">
            <svg t="1743769783333" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="2616" width="32" height="32"><path d="M512 0C229.23264 0 0 229.23264 0 512c0 282.76736 229.23264 512 512 512 51.623253 0 101.451093-7.673173 148.43904-21.886293 127.91808-38.68672 234.666667-126.07488 298.707627-240.59904 25.78432-46.107307 44.632747-96.610987 55.166293-150.09792 0.054613-0.273067 0.12288-0.53248 0.177493-0.805547C1020.7232 578.70336 1024 545.737387 1024 512 1024 229.23264 794.76736 0 512 0zM823.958187 542.180693l-281.750187 281.750187c-16.329387 16.308907-42.769067 16.308907-59.06432 0L215.69536 556.516693l-12.192427-12.192427-3.46112-3.46112c-16.308907-16.308907-16.308907-42.728107 0-59.057493l132.87424-132.860587 0.34816-0.34816 54.12864-54.114987 49.493333 49.493333c-3.80928 7.92576-5.9392 16.820907-5.9392 26.200747 0 26.48064 16.91648 48.96768 40.523093 57.316693l0 169.04192c-23.606613 8.349013-40.523093 30.856533-40.523093 57.316693 0 33.573547 27.211093 60.78464 60.78464 60.78464s60.78464-27.211093 60.78464-60.78464c0-26.48064-16.923307-48.96768-40.523093-57.316693L511.993173 427.47904c2.02752-0.709973 4.007253-1.51552 5.9392-2.450773l81.025707 81.025707c-3.80928 7.92576-5.9392 16.820907-5.9392 26.200747 0 33.573547 27.211093 60.78464 60.78464 60.78464 33.573547 0 60.78464-27.211093 60.78464-60.78464 0-33.573547-27.211093-60.78464-60.78464-60.78464-9.37984 0-18.254507 2.1504-26.200747 5.9392L546.583893 396.383573c3.80928-7.92576 5.9392-16.820907 5.9392-26.200747 0-33.573547-27.211093-60.78464-60.78464-60.78464-9.37984 0-18.254507 2.1504-26.200747 5.9392l-49.493333-49.493333 27.613867-27.613867 0.211627-0.211627 10.67008-10.67008 27.27936-27.27936c16.329387-16.308907 42.769067-16.308907 59.057493 0l76.32896 76.322133 19.203413 19.196587 187.55584 187.542187 0-0.02048C840.267093 499.411627 840.267093 525.871787 823.958187 542.180693z" p-id="2617" fill="#1296db"></path></svg>
            <h2>GitNexus - 邮箱验证码</h2>
        </div>
        
        <p>尊敬的用户：</p>
        <p>您正在本站进行邮箱验证操作，如非您本人操作，请忽略此邮件。</p>
        <p>您的验证码为：</p>
        <div class="code">
            ${code}
        </div>
        <p class="important">验证码5分钟内有效，超时请重新获取</p>
        <p class="footer">Copyright © 2025 Gitnexus.cn</p>
    </div>
</body>

</html>`
        )
    }

    async registerSuccess(email, username) {
        const time = new Date().getTime()
        await sendEmail(email, '您已成功注册GitNexus账号',
            `<html lang="zh-CN">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>GitNexus - 邮箱验证码</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }

        .container {
            width: 80%;
            margin: 20px auto;
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }

        .head {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 10px;
            color: #2c3e50;
        }

        p {
            font-size: 16px;
            color: #34495e;
            line-height: 1.6;
            text-indent: 2em;
        }

        .info {
            background-color: #ecf0f1;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }

        .info p {
            margin: 5px 0;
        }

        .important {
            color: #e74c3c;
            font-weight: bold;
        }

        .footer {
            font-size: 14px;
            text-align: center;
            color: #7f8c8d;
            margin-top: 50px;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="head">
            <svg t="1743769783333" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg"
                p-id="2616" width="32" height="32">
                <path
                    d="M512 0C229.23264 0 0 229.23264 0 512c0 282.76736 229.23264 512 512 512 51.623253 0 101.451093-7.673173 148.43904-21.886293 127.91808-38.68672 234.666667-126.07488 298.707627-240.59904 25.78432-46.107307 44.632747-96.610987 55.166293-150.09792 0.054613-0.273067 0.12288-0.53248 0.177493-0.805547C1020.7232 578.70336 1024 545.737387 1024 512 1024 229.23264 794.76736 0 512 0zM823.958187 542.180693l-281.750187 281.750187c-16.329387 16.308907-42.769067 16.308907-59.06432 0L215.69536 556.516693l-12.192427-12.192427-3.46112-3.46112c-16.308907-16.308907-16.308907-42.728107 0-59.057493l132.87424-132.860587 0.34816-0.34816 54.12864-54.114987 49.493333 49.493333c-3.80928 7.92576-5.9392 16.820907-5.9392 26.200747 0 26.48064 16.91648 48.96768 40.523093 57.316693l0 169.04192c-23.606613 8.349013-40.523093 30.856533-40.523093 57.316693 0 33.573547 27.211093 60.78464 60.78464 60.78464s60.78464-27.211093 60.78464-60.78464c0-26.48064-16.923307-48.96768-40.523093-57.316693L511.993173 427.47904c2.02752-0.709973 4.007253-1.51552 5.9392-2.450773l81.025707 81.025707c-3.80928 7.92576-5.9392 16.820907-5.9392 26.200747 0 33.573547 27.211093 60.78464 60.78464 60.78464 33.573547 0 60.78464-27.211093 60.78464-60.78464 0-33.573547-27.211093-60.78464-60.78464-60.78464-9.37984 0-18.254507 2.1504-26.200747 5.9392L546.583893 396.383573c3.80928-7.92576 5.9392-16.820907 5.9392-26.200747 0-33.573547-27.211093-60.78464-60.78464-60.78464-9.37984 0-18.254507 2.1504-26.200747 5.9392l-49.493333-49.493333 27.613867-27.613867 0.211627-0.211627 10.67008-10.67008 27.27936-27.27936c16.329387-16.308907 42.769067-16.308907 59.057493 0l76.32896 76.322133 19.203413 19.196587 187.55584 187.542187 0-0.02048C840.267093 499.411627 840.267093 525.871787 823.958187 542.180693z"
                    p-id="2617" fill="#1296db"></path>
            </svg>
            <h2>GitNexus - 邮箱验证码</h2>
        </div>

        <p>尊敬的 ${username}：</p>
        <p>您已成功注册GitNexus账号：</p>
        <div class="info">
            <p><strong>用户名：</strong> ${username}</p>
            <p><strong>注册时间：</strong> ${this.stramptoTime(time)}</p>
        </div>

        <p class="footer">Copyright © 2025 Gitnexus.cn</p>
    </div>
</body>

</html>`
        )
    }
}

const EmailTemplate = new emailTemplate()
module.exports = EmailTemplate