const nodemailer = require('nodemailer');
const config = require('../../config.json');
const path = require('path');
const Logger = require('../../lib/Logger');

const logger = new Logger(path.join(__dirname, '../../logs/Email.log'), 'INFO');

const transporter = nodemailer.createTransport({
    host: config.email.host,
    port: config.email.port,
    secure: config.email.secure,
    auth: {
        user: config.email.user,
        pass: config.email.password
    }
})

async function sendEmail(email, subject, content) {
    return new Promise((resolve, reject) => {
        const mail = {
            from: `GitNexus <${transporter.options.auth.user}>`,
            to: email,
            subject: subject,
            html: content
        }
        try {
            transporter.sendMail(mail, (error) => {
                if (error) {
                    logger.error('邮件发送失败:', error);
                    reject(error);
                } else {
                    resolve();
                }
            })
        } catch (error) {
            logger.error('邮件发送失败:', error);
            reject(error);
        }
    })
}

module.exports = sendEmail;