const db = require('../plugin/DataBase/db');

class UserInfoCache {
    async getUserByUuid(uuid) {
        const sql = 'SELECT uuid, username, avatar FROM users WHERE uuid = ?';
        const rows = await db.query(sql, [uuid]);

        return rows[0] ? rows[0] : null;
    }

    async getUuidByName(name) {
        const sql = 'SELECT uuid, username, avatar FROM users WHERE name = ?';
        const rows = await db.query(sql, [name]);

        return rows[0] ? rows[0] : null;
    }
}

module.exports = new UserInfoCache();
