const db = require('../plugin/DataBase/db');

class AccessControl {
    async checkSession(uuid, session) {
        const sql = 'SELECT uuid, session FROM users WHERE uuid = ? AND session = ?';
        const rows = await db.query(sql, [uuid, session]);
        return rows.length > 0;
    }

    async getPermission(uuid) {
        const sql = 'SELECT permission FROM users WHERE uuid = ?';
        const rows = await db.query(sql, [uuid]);

        return rows[0].permission || [];
    }

    async checkJwAccount(uuid, username) {
        const sql = 'SELECT password FROM jw_account WHERE create_user = ? AND state = 1 AND username = ?'
        const rows = await db.query(sql, [uuid, username]);
        if (!rows || rows.length !== 1 || !rows[0].password)
            return false
        return rows[0].password;
    }
}

module.exports = new AccessControl();
