const express = require('express');
const Logger = require('./Logger');
const path = require('path');

class API {
    constructor() {
        this.router = express.Router();
        this.namespace = '';
        this.path = '';
        this.method = 'get';

        this.logger = new Logger(path.join(__dirname, '../logs/API.log'), 'INFO');
    }

    setPath(path) {
        this.path = path;
    }

    setMethod(method) {
        this.method = method.toLowerCase();
    }

    getRouter() {
        return this.router;
    }

    async onRequest(req, res) {
        throw new Error('onRequest方法未实现');
    }

    setupRoute() {
        this.router[this.method](this.path, async (req, res) => {
            await this.onRequest(req, res);
        });
    }
}

module.exports = API;
