const { v4: uuidv4 } = require('uuid');
const API = require("../../lib/API");
const bcryptjs = require('bcryptjs');
const { BaseStdResponse } = require("../../BaseStdResponse");
const db = require("../../plugin/DataBase/db");
const Redis = require('../../plugin/DataBase/Redis');

// 用户登录
class Login extends API {
    constructor() {
        super();

        this.setMethod("POST");
        this.setPath("/User/Login");
    }

    async onRequest(req, res) {
        let { username, password, captcha, id } = req.body;

        if ([username, password, captcha, id].some(value => value === '' || value === null || value === undefined)) {
            res.json({
                ...BaseStdResponse.MISSING_PARAMETER,
                endpoint: 1513126
            });
            return;
        }

        password = atob(password);

        try {
            const code = await Redis.get(`captcha:${id}`);
            if (!code || code != captcha.toLowerCase())
                return res.json({
                    ...BaseStdResponse.ERR,
                    msg: '验证码错误或已过期！'
                })
            Redis.del(`captcha:${id}`);
        } catch (err) {
            this.logger.error(`验证图片验证码失败！${err.stack}`);
            return res.json({
                ...BaseStdResponse.DATABASE_ERR,
                msg: '验证失败！'
            })
        }

        let sql = 'SELECT id, uuid, password, username, permission, avatar, email  FROM users WHERE username = ?';
        let rows = await db.query(sql, [username]);

        if (!rows || rows.length !== 1 || !bcryptjs.compareSync(password, rows[0].password))
            return res.json({
                ...BaseStdResponse.ERR,
                msg: '用户名或密码错误'
            })

        const session = uuidv4();

        sql = 'UPDATE users SET session = ? WHERE id = ?';
        let result = await db.query(sql, [session, rows[0].id]);

        if (result && result.affectedRows > 0) {
            res.json({
                ...BaseStdResponse.OK,
                data: {
                    uuid: rows[0].uuid,
                    username: rows[0].username,
                    session,
                    avatar: rows[0].avatar,
                    email: rows[0].email,
                    roles: rows[0].permission || []
                }
            });
        } else {
            res.json({ ...BaseStdResponse.ERR, endpoint: 7894378, msg: '登录失败！' });
        }
    }
}

module.exports.Login = Login;
