const API = require("../../lib/API");
const db = require("../../plugin/DataBase/db");
const AccessControl = require("../../lib/AccessControl");
const { BaseStdResponse } = require("../../BaseStdResponse");

class GetRepoList extends API {
    constructor() {
        super();

        this.setPath('/User/Info')
        this.setMethod('GET')
    }

    async onRequest(req, res) {
        let {
            uuid,
            session
        } = req.query

        if ([uuid, session].some(value => value === '' || value === null || value === undefined))
            return res.json({
                ...BaseStdResponse.MISSING_PARAMETER
            })

        // 检查 session
        if (!await AccessControl.checkSession(uuid, session))
            return res.status(401).json({
                ...BaseStdResponse.ACCESS_DENIED
            })

        let sql = 'SELECT uuid, session, username, permission AS roles, avatar, email, registTime FROM users WHERE uuid = ?'
        let rows = await db.query(sql, [uuid])

        if (!rows || rows.length === 0)
            return res.json({
                ...BaseStdResponse.MISSING_FILE,
                msg: '获取用户信息失败！'
            })

        res.json({
            ...BaseStdResponse.OK,
            data: rows[0]
        })
    }
}

module.exports.GetRepoList = GetRepoList;