const API = require("../../lib/API")
const db = require("../../plugin/DataBase/db")
const AccessControl = require("../../lib/AccessControl")
const { BaseStdResponse } = require("../../BaseStdResponse")
class GetRepos extends API {
    constructor() {
        super()

        this.setPath('/User/GetRepos')
        this.setMethod('GET')
    }

    async onRequest(req, res) {
        let {
            uuid,
            session
        } = req.query

        if ([uuid, session].some(value => value === '' || value === null || value === undefined))
            return res.json({
                ...BaseStdResponse.MISSING_PARAMETER
            })

        // 检查 session
        if (!await AccessControl.checkSession(uuid, session))
            return res.status(401).json({
                ...BaseStdResponse.ACCESS_DENIED
            })

        let sql = 'SELECT id, name, url, logo, create_time, update_time FROM repos WHERE create_user = ? AND state = 1 ORDER BY update_time DESC LIMIT 6'
        let rows = await db.query(sql, [uuid])

        if (!rows)
            return res.json({
                ...BaseStdResponse.ERR,
                msg: '数据库错误！'
            })

        res.json({
            ...BaseStdResponse.OK,
            data: rows
        })
    }
}

module.exports.GetRepos = GetRepos