const API = require("../../lib/API");
const { BaseStdResponse } = require("../../BaseStdResponse");
const AccessControl = require("../../lib/AccessControl");

// 获取用户权限
class GetPermissions extends API {
    constructor() {
        super();

        this.setMethod("GET");
        this.setPath("/User/GetPermissions");
    }

    async onRequest(req, res) {
        let {
            uuid,
            session
        } = req.query;

        // 检查必需的参数是否缺失
        if ([uuid, session].some(value => value === '' || value === null || value === undefined)) {
            res.json({
                ...BaseStdResponse.MISSING_PARAMETER,
                endpoint: 1513123
            });
            return;
        }

        // 检查 session 是否有效
        if (!await AccessControl.checkSession(uuid, session)) {
            res.status(401).json({
                ...BaseStdResponse.ACCESS_DENIED,
                endpoint: 48153145
            });
            return;
        }

        let permission = await AccessControl.getPermission(uuid);

        res.json({
            ...BaseStdResponse.OK,
            roles: permission
        });
    }
}

module.exports.GetPermissions = GetPermissions;
