const API = require("../../lib/API")
const AccessControl = require("../../lib/AccessControl")
const { BaseStdResponse } = require("../../BaseStdResponse")
const db = require("../../plugin/DataBase/db")

// 更新仓库信息
class UpdateRepoInfo extends API {
    constructor() {
        super()

        this.setMethod("POST")
        this.setPath("/Repos/UpdateInfo")
    }

    checkName(name) {
        const regex = /^(?!\.)(?!.*\/{2,})(?!.*\.git$)[\u4E00-\u9FA5A-Za-z0-9._-]+(?<!\/)$/
        return regex.test(name)
    }

    async onRequest(req, res) {
        let { uuid, session, name, id } = req.body

        if ([uuid, session, name, id].some(value => value === '' || value === null || value === undefined))
            return res.json({
                ...BaseStdResponse.MISSING_PARAMETER
            })

        if (!this.checkName(name))
            return res.json({
                ...BaseStdResponse.ERR,
                msg: '仓库名称不合法！'
            })

        // 检查 session
        if (!await AccessControl.checkSession(uuid, session))
            return res.status(401).json({
                ...BaseStdResponse.ACCESS_DENIED
            })

        let sql = 'UPDATE repos SET \`name\` = ? WHERE create_user = ? AND id = ?'

        let result = await db.query(sql, [name, uuid, id])

        if (result && result.affectedRows > 0) {
            res.json({
                ...BaseStdResponse.OK
            })
        } else {
            res.json({ ...BaseStdResponse.ERR, endpoint: 7894378, msg: '更新仓库信息失败！' })
        }
    }
}

module.exports.UpdateRepoInfo = UpdateRepoInfo
