const API = require("../../lib/API")
const AccessControl = require("../../lib/AccessControl")
const { BaseStdResponse } = require("../../BaseStdResponse")
const db = require("../../plugin/DataBase/db")
const redis = require('../../plugin/DataBase/Redis')
const fs = require('fs')

// 删除仓库
class DeleteRepo extends API {
    constructor() {
        super()

        this.setMethod("DELETE")
        this.setPath("/Repos")
    }

    async onRequest(req, res) {
        let { uuid, session, id } = req.body

        if ([uuid, session, id].some(value => value === '' || value === null || value === undefined))
            return res.json({
                ...BaseStdResponse.MISSING_PARAMETER
            })

        // 检查 session
        if (!await AccessControl.checkSession(uuid, session))
            return res.status(401).json({
                ...BaseStdResponse.ACCESS_DENIED
            })
        let sql = 'SELECT path FROM repos WHRER \`create_user\` = ? AND id = ?'
        let r = await db.query(sql, [uuid, id])

        if (r && r[0].path) {
            const redisKey = [`gitLogs:${r[0].path}`,`contributors:${r[0].path}`,`codeStats:${r[0].path}`]
            await redis.del(redisKey)

            fs.rm(r[0].path, { recursive: true, force: true }, (err) => { 
                this.logger.error('删除仓库失败！' + err)
                res.json({ ...BaseStdResponse.ERR, endpoint: 7894378, msg: '删除仓库失败！' })
            })
        }
            
        sql = 'DELETE FROM repos WHERE create_user = ? AND id = ?'

        let result = await db.query(sql, [uuid, id])

        if (result && result.affectedRows > 0) {
            res.json({
                ...BaseStdResponse.OK
            })

        } else {
            res.json({ ...BaseStdResponse.ERR, endpoint: 7894378, msg: '删除仓库失败！' })
        }
    }
}

module.exports.DeleteRepo = DeleteRepo
