const API = require("../../lib/API")
const AccessControl = require("../../lib/AccessControl")
const { BaseStdResponse } = require("../../BaseStdResponse")
const db = require("../../plugin/DataBase/db")
const redis = require('../../plugin/DataBase/Redis')
const simpleGit = require('simple-git')

class GitPull extends API {
    constructor() {
        super()

        this.setMethod("GET")
        this.setPath("/GitActions/GitPull")
    }

    async onRequest(req, res) {
        let { uuid, session, id } = req.query

        if ([uuid, session, id].some(value => value === '' || value === null || value === undefined))
            return res.json({
                ...BaseStdResponse.MISSING_PARAMETER
            })

        // 检查 session
        if (!await AccessControl.checkSession(uuid, session))
            return res.status(401).json({
                ...BaseStdResponse.ACCESS_DENIED
            })

        let sql = 'SELECT state, path, url FROM repos WHERE create_user = ? AND id = ?'
        let r = await db.query(sql, [uuid, id])
        if (!r || r.length === 0)
            return res.json({
                ...BaseStdResponse.ERR,
                msg: '未找到仓库'
            })

        if (r[0].state !== 1 || !r[0].path)
            return res.json({
                ...BaseStdResponse.ERR,
                msg: '仓库未成功克隆！'
            })

        try {
            const redisKey = [`gitLogs:${r[0].path}`,`contributors:${r[0].path}`,`codeStats:${r[0].path}`]
            await redis.del(redisKey)

            const git = simpleGit()
            await git.cwd(r[0].path)
            await git.pull()

            res.json({
                ...BaseStdResponse.OK
            })

            const time = new Date().getTime()
            sql = 'UPDATE repos SET update_time = ? WHERE create_user = ? AND id = ?'
            await db.query(sql, [time, uuid, id])
        } catch (error) {
            this.logger.error('拉取更新失败！' + error.stack)
            return res.json({
                ...BaseStdResponse.ERR,
                msg: '拉取更新失败！'
            })
        }

    }
}

module.exports.GitPull = GitPull
