const API = require("../../lib/API")
const AccessControl = require("../../lib/AccessControl")
const { BaseStdResponse } = require("../../BaseStdResponse")
const db = require("../../plugin/DataBase/db")
const redis = require('../../plugin/DataBase/Redis')
const simpleGit = require('simple-git')

class ChangeBranch extends API {
    constructor() {
        super()

        this.setMethod("GET")
        this.setPath("/GitActions/ChangeBranch")
    }

    async onRequest(req, res) {
        let { uuid, session, id, branch } = req.query

        if ([uuid, session, id, branch ].some(value => value === '' || value === null || value === undefined))
            return res.json({
                ...BaseStdResponse.MISSING_PARAMETER
            })

        // 检查 session
        if (!await AccessControl.checkSession(uuid, session))
            return res.status(401).json({
                ...BaseStdResponse.ACCESS_DENIED
            })

        let sql = 'SELECT state, path, url FROM repos WHERE create_user = ? AND id = ?'
        let r = await db.query(sql, [uuid, id])
        if (!r || r.length === 0)
            return res.json({
                ...BaseStdResponse.ERR,
                msg: '未找到仓库'
            })

        if (r[0].state !== 1 || !r[0].path)
            return res.json({
                ...BaseStdResponse.ERR,
                msg: '仓库未成功克隆！'
            })

        try {
            const redisKey = [`gitLogs:${r[0].path}`,`contributors:${r[0].path}`,`codeStats:${r[0].path}`]
            await redis.del(redisKey)

            const git = simpleGit()
            await git.cwd(r[0].path)

            const branches = await git.branch()
            const remoteBranch = 'remotes/origin/' + branch
            if(!branches.all.includes(branch) && !branches.all.includes(remoteBranch))
                return res.json({
                    ...BaseStdResponse.ERR,
                    msg: '分支不存在！'
                })

            await git.checkout(branch)
            
            res.json({
                ...BaseStdResponse.OK
            })

        } catch (error) {
            this.logger.error('切换仓库分支失败！' + error.stack)
            return res.json({
                ...BaseStdResponse.ERR,
                msg: '切换仓库分支失败！'
            })
        }

    }
}

module.exports.ChangeBranch = ChangeBranch
