const API = require("../../lib/API")
const AccessControl = require("../../lib/AccessControl")
const { BaseStdResponse } = require("../../BaseStdResponse")
const db = require("../../plugin/DataBase/db")
const axios = require('axios')
const simpleGit = require('simple-git')
const { core_url } = require('../../config.json')

class ScanRepo extends API {
    constructor() {
        super()

        this.setMethod("GET")
        this.setPath("/AI/ScanRepo")
    }

    async onRequest(req, res) {
        let { uuid, session, id } = req.query

        if ([uuid, session, id].some(value => value === '' || value === null || value === undefined))
            return res.json({
                ...BaseStdResponse.MISSING_PARAMETER
            })

        // 检查 session
        if (!await AccessControl.checkSession(uuid, session))
            return res.status(401).json({
                ...BaseStdResponse.ACCESS_DENIED
            })

        let sql = 'SELECT state, path, url FROM repos WHERE create_user = ? AND id = ?'
        let rows = await db.query(sql, [uuid, id])
        if (!rows || rows.length === 0)
            return res.json({
                ...BaseStdResponse.ERR,
                msg: '未找到仓库'
            })

        if (rows[0].state !== 1 || !rows[0].path)
            return res.json({
                ...BaseStdResponse.ERR,
                msg: '仓库未成功克隆！'
            })

        try {
            const git = simpleGit()
            await git.cwd(rows[0].path)
            const hash = await git.revparse(['HEAD'])
            const time = new Date().getTime()

            sql = 'INSERT INTO scan_tasks (repo_id, create_time, create_user, repo_hash, source) VALUES (?, ?, ?, ?, ?)'
            let r = await db.query(sql, [id, time, uuid, hash, 'hand'])
            if(!r || r.affectedRows !== 1)
                return res.json({
                    ...BaseStdResponse.ERR,
                    msg: '扫描任务添加失败！'
                })

            res.json({
                ...BaseStdResponse.OK
            })

            let endpoint = core_url + '/ai/scan'
            await axios.post(endpoint, { uuid, repo_url: rows[0].url, task_id: String(r.insertId), repo_id: id })
        } catch (error) {
            this.logger.error('获取仓库历史失败！' + error.stack)
        }

    }
}

module.exports.ScanRepo = ScanRepo
