const API = require("../../lib/API")
const db = require("../../plugin/DataBase/db")
const AccessControl = require("../../lib/AccessControl")
const { BaseStdResponse } = require("../../BaseStdResponse")

class GetScanTaskList extends API {
    constructor() {
        super()

        this.setPath('/AI/GetScanTaskList')
        this.setMethod('GET')
    }

    async onRequest(req, res) {
        let { uuid, session, id } = req.query
        if ([uuid, session, id].some(value => value === '' || value === null || value === undefined))
            return res.json({
                ...BaseStdResponse.MISSING_PARAMETER
            })

        // 检查 session
        if (!await AccessControl.checkSession(uuid, session))
            return res.status(401).json({
                ...BaseStdResponse.ACCESS_DENIED
            })

        let sql = 'SELECT id, create_time, scan_start_time, scan_end_time, result, repo_hash, state, repo_id, type, source FROM scan_tasks WHERE create_user = ? AND repo_id = ? ORDER BY id DESC'
        let rows = await db.query(sql, [uuid, id])

        if (!rows || rows.length === 0)
            return res.json({
                ...BaseStdResponse.OK,
                data: []
            })

        res.json({
            ...BaseStdResponse.OK,
            data: rows
        })

    }
}

module.exports.GetScanTaskList = GetScanTaskList