const API = require("../../lib/API")
const db = require("../../plugin/DataBase/db")
const AccessControl = require("../../lib/AccessControl")
const { BaseStdResponse } = require("../../BaseStdResponse")

class GetScanTaskDetail extends API {
    constructor() {
        super()

        this.setPath('/AI/GetScanTaskDetail')
        this.setMethod('GET')
    }

    async onRequest(req, res) {
        let { uuid, session, id, task_id } = req.query
        if ([uuid, session, id, task_id].some(value => value === '' || value === null || value === undefined))
            return res.json({
                ...BaseStdResponse.MISSING_PARAMETER
            })

        // 检查 session
        if (!await AccessControl.checkSession(uuid, session))
            return res.status(401).json({
                ...BaseStdResponse.ACCESS_DENIED
            })

        let sql = 'SELECT id, create_time, scan_start_time, scan_end_time, result, repo_hash, state, repo_id, type, source FROM scan_tasks WHERE create_user = ? AND repo_id = ? AND id  = ? ORDER BY id DESC'
        let rows = await db.query(sql, [uuid, id, task_id])

        if (!rows || rows.length === 0)
            return res.json({
                ...BaseStdResponse.OK,
                data: []
            })

        res.json({
            ...BaseStdResponse.OK,
            data: rows
        })

    }
}

module.exports.GetScanTaskDetail = GetScanTaskDetail