const API = require("../../lib/API")
const db = require("../../plugin/DataBase/db")
const AccessControl = require("../../lib/AccessControl")
const { BaseStdResponse } = require("../../BaseStdResponse")
const path = require('path')

class GetFileSummary extends API {
    constructor() {
        super()

        this.setPath('/AI/GetFileSummary')
        this.setMethod('GET')
    }

    async onRequest(req, res) {
        let { uuid, session, id, hash, filePath } = req.query
        if ([uuid, session, id, hash, filePath].some(value => value === '' || value === null || value === undefined))
            return res.json({
                ...BaseStdResponse.MISSING_PARAMETER
            })

        // 检查 session
        if (!await AccessControl.checkSession(uuid, session))
            return res.status(401).json({
                ...BaseStdResponse.ACCESS_DENIED
            })

        let sql = 'SELECT state, path FROM repos WHERE create_user = ? AND id = ?'
        let rows = await db.query(sql, [uuid, id])
        if (!rows || rows.length === 0)
            return res.json({
                ...BaseStdResponse.ERR,
                msg: '未找到仓库'
            })

        if (rows[0].state !== 1 || !rows[0].path)
            return res.json({
                ...BaseStdResponse.ERR,
                msg: '仓库未成功克隆！'
            })

        filePath = path.join(rows[0].path, filePath)

        sql = 'SELECT create_time, start_time, end_time, result, repo_hash FROM file_summary_tasks WHERE create_user = ? AND repo_id = ? AND repo_hash = ? AND filepath = ?'
        rows = await db.query(sql, [uuid, id, hash, filePath])

        if (!rows || rows.length === 0)
            return res.json({
                ...BaseStdResponse.OK,
                data: []
            })

        res.json({
            ...BaseStdResponse.OK,
            data: rows
        })

    }
}

module.exports.GetFileSummary = GetFileSummary