const API = require("../../lib/API")
const db = require("../../plugin/DataBase/db")
const AccessControl = require("../../lib/AccessControl")
const { BaseStdResponse } = require("../../BaseStdResponse")

class GetCommitSummary extends API {
    constructor() {
        super()

        this.setPath('/AI/GetCommitSummary')
        this.setMethod('GET')
    }

    async onRequest(req, res) {
        let {uuid, session, id, hash } = req.query
        if ([uuid, session, id, hash].some(value => value === '' || value === null || value === undefined))
            return res.json({
                ...BaseStdResponse.MISSING_PARAMETER
            })

        // 检查 session
        if (!await AccessControl.checkSession(uuid, session))
            return res.status(401).json({
                ...BaseStdResponse.ACCESS_DENIED
            })

        let sql = 'SELECT create_time, start_time, end_time, result, repo_hash FROM commit_summary_tasks WHERE create_user = ? AND repo_id = ? AND repo_hash = ?'
        let rows = await db.query(sql, [uuid, id, hash])

        if (!rows || rows.length === 0)
            return res.json({
                ...BaseStdResponse.OK,
                data: []
            })

        res.json({
            ...BaseStdResponse.OK,
            data: rows
        })

    }
}

module.exports.GetCommitSummary = GetCommitSummary