const API = require("../../lib/API")
const db = require("../../plugin/DataBase/db")
const Redis = require('../../plugin/DataBase/Redis')
const AccessControl = require("../../lib/AccessControl")
const { BaseStdResponse } = require("../../BaseStdResponse")

class GetAIChatMessage extends API {
    constructor() {
        super()

        this.setPath('/AI/GetAIChatMessage')
        this.setMethod('GET')
    }

    async onRequest(req, res) {
        let { uuid, session, id } = req.query
        if ([uuid, session].some(value => value === '' || value === null || value === undefined))
            return res.json({
                ...BaseStdResponse.MISSING_PARAMETER
            })

        // 检查 session
        if (!await AccessControl.checkSession(uuid, session))
            return res.status(401).json({
                ...BaseStdResponse.ACCESS_DENIED
            })

        const data = await Redis.get(`message:${id}`)
       
        res.json({
            ...BaseStdResponse.OK,
            data
        })

    }
}

module.exports.GetAIChatMessage = GetAIChatMessage