const API = require("../../lib/API")
const db = require("../../plugin/DataBase/db")
const AccessControl = require("../../lib/AccessControl")
const { BaseStdResponse } = require("../../BaseStdResponse")

class DeleteAIChatMessages extends API {
    constructor() {
        super()

        this.setPath('/AI/DeleteAIChatMessages')
        this.setMethod('GET')
    }

    async onRequest(req, res) {
        let { uuid, session } = req.query
        if ([uuid, session].some(value => value === '' || value === null || value === undefined))
            return res.json({
                ...BaseStdResponse.MISSING_PARAMETER
            })

        // 检查 session
        if (!await AccessControl.checkSession(uuid, session))
            return res.status(401).json({
                ...BaseStdResponse.ACCESS_DENIED
            })

        let sql = 'DELETE FROM messages WHERE uuid = ?'
        await db.query(sql, [uuid])

        res.json({
            ...BaseStdResponse.OK
        })

    }
}

module.exports.DeleteAIChatMessages = DeleteAIChatMessages