let BaseStdResponse = {
    OK:{
        code:0,
        msg:'ok'
    },
    ERR:{
        code:-1,
        msg:'err'
    },
    MISSING_PARAMETER:{//缺少参数
        code:-2,
        msg:'Missing parameter'
    },
    MISSING_FILE:{//找不到文件
        code:-404,
        msg:'Missing file'
    },
    METHOD_NOT_EXIST:{//方法不存在
        code:-400,
        msg:'Method not exist'
    },
    ACCESS_DENIED:{//访问拒绝：通常是AK不正确
        code:-100,
        msg:"Access denied"
    },
    UNDER_DEVELOPMENT:{//处于开发中
        code:-201,
        msg:"Under development"
    },
    DATABASE_CONNECT_FAIL:{
        code:-500,
        msg:"Database connect fail"
    },
    DATABASE_ERR:{
        code:-501,
        msg:"Database err"
    },
    DATABASE_NOT_FOUNT:{
        code:-504,
        msg:"Database not fount"
    },
    REQUEST_BUSY:{
        code:-505,
        msg:"Request busy!",
    },
    
    // 用户相关
    USER_NOT_EXISTS:{//用户不存在
        code:-20404,
        msg:"User not exists"
    },
    USER_ALREADY_EXISTS:{
        code:-20405,
        msg:"User already exists"
    },
    USER_ACCESS_DENIED:{//用户密码错误
        code:-20500,
        msg:"User access denied"
    },
    USER_ILLEAGAL_NAME:{
        code:-20501,
        msg:"User illeagal name"
    },

    // 短信相关业务
    SMS_SEND_COOLING:{// 验证码冷却
        code:-10500,
        msg:"Sms send cooling"
    },
    SMS_SEND_FAIL:{// 发送失败
        code:-10300,
        msg:"Sms send fail"
    },
    SMS_CHECK_FAIL:{// 短信验证失败
        code:-10501,
        msg:"Sms check fail"
    },

    //权限相关
    PERMISSION_DENIED:{//权限不足
        code:-403,
        msg:"Permission denied"
    },
}
module.exports.BaseStdResponse = BaseStdResponse;